/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Platform;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.PointerCData;
import org.python.modules.jffi.StructLayout;
import org.python.modules.jffi.Structure;
import org.python.modules.jffi.Util;

abstract class MemoryOp {
    public static final MemoryOp INVALID = new InvalidOp();
    public static final MemoryOp VOID = new VoidOp();
    public static final MemoryOp BOOL = new BooleanOp();
    public static final MemoryOp INT8 = new Signed8();
    public static final MemoryOp UINT8 = new Unsigned8();
    public static final MemoryOp INT16 = new Signed16();
    public static final MemoryOp UINT16 = new Unsigned16();
    public static final MemoryOp INT32 = new Signed32();
    public static final MemoryOp UINT32 = new Unsigned32();
    public static final MemoryOp INT64 = new Signed64();
    public static final MemoryOp UINT64 = new Unsigned64();
    public static final MemoryOp FLOAT = new Float32();
    public static final MemoryOp DOUBLE = new Float64();
    public static final MemoryOp POINTER = new PointerOp(PointerCData.TYPE, CType.POINTER);
    public static final MemoryOp STRING = new StringOp();

    MemoryOp() {
    }

    public static final MemoryOp getMemoryOp(NativeType nativeType) {
        switch (nativeType) {
            case VOID: {
                return VOID;
            }
            case BYTE: {
                return INT8;
            }
            case UBYTE: {
                return UINT8;
            }
            case SHORT: {
                return INT16;
            }
            case USHORT: {
                return UINT16;
            }
            case INT: {
                return INT32;
            }
            case UINT: {
                return UINT32;
            }
            case LONGLONG: {
                return INT64;
            }
            case ULONGLONG: {
                return UINT64;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? INT32 : INT64;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? UINT32 : UINT64;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case POINTER: {
                return POINTER;
            }
            case STRING: {
                return STRING;
            }
            case BOOL: {
                return BOOL;
            }
        }
        throw new UnsupportedOperationException("No MemoryOp for " + (Object)((Object)nativeType));
    }

    abstract PyObject get(Memory var1, long var2);

    abstract void put(Memory var1, long var2, PyObject var4);

    private static final class BooleanOp
    extends MemoryOp {
        private BooleanOp() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putInt(l, pyObject.__nonzero__() ? 1 : 0);
        }

        public final PyObject get(Memory memory, long l) {
            return Py.newBoolean(memory.getInt(l) != 0);
        }
    }

    static final class Float32
    extends MemoryOp {
        Float32() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putFloat(l, Util.floatValue(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Py.newFloat(memory.getFloat(l));
        }
    }

    static final class Float64
    extends MemoryOp {
        Float64() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putDouble(l, Util.doubleValue(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Py.newFloat(memory.getDouble(l));
        }
    }

    private static final class InvalidOp
    extends MemoryOp {
        private InvalidOp() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            throw Py.TypeError("invalid memory access");
        }

        public final PyObject get(Memory memory, long l) {
            throw Py.TypeError("invalid memory access");
        }
    }

    static final class PointerOp
    extends MemoryOp {
        private final PyType pytype;
        private final CType ctype;

        public PointerOp(PyType pyType, CType cType) {
            this.pytype = pyType;
            this.ctype = cType;
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            if (pyObject instanceof Pointer) {
                memory.putAddress(l, ((Pointer)((Object)pyObject)).getMemory().getAddress());
            } else if (pyObject == Py.None) {
                memory.putAddress(l, 0L);
            } else {
                throw Py.RuntimeError("invalid pointer");
            }
        }

        public final PyObject get(Memory memory, long l) {
            NativeMemory nativeMemory = new NativeMemory(memory.getAddress(l));
            return new PointerCData(this.pytype, this.ctype, nativeMemory, INVALID);
        }
    }

    static final class Signed16
    extends MemoryOp {
        Signed16() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putShort(l, Util.int16Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newSigned16(memory.getShort(l));
        }
    }

    static final class Signed32
    extends MemoryOp {
        Signed32() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putInt(l, Util.int32Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newSigned32(memory.getInt(l));
        }
    }

    static final class Signed64
    extends MemoryOp {
        Signed64() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putLong(l, Util.int64Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newSigned64(memory.getLong(l));
        }
    }

    static final class Signed8
    extends MemoryOp {
        Signed8() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putByte(l, Util.int8Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newSigned8(memory.getByte(l));
        }
    }

    private static final class StringOp
    extends MemoryOp {
        private StringOp() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            throw Py.NotImplementedError("Cannot set String");
        }

        public final PyObject get(Memory memory, long l) {
            throw Py.NotImplementedError("Cannot get String");
        }
    }

    static final class StructOp
    extends MemoryOp {
        private final PyType type;
        private final StructLayout layout;

        public StructOp(PyType pyType) {
            this.type = pyType;
            PyObject pyObject = pyType.__getattr__("_jffi_type");
            if (!(pyObject instanceof StructLayout)) {
                throw Py.TypeError("invalid _jffi_type for " + pyType.fastGetName() + "; should be instance of jffi.StructLayout");
            }
            this.layout = (StructLayout)pyObject;
        }

        public StructOp(PyType pyType, StructLayout structLayout) {
            this.type = pyType;
            this.layout = structLayout;
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            throw Py.NotImplementedError("not implemented");
        }

        public final PyObject get(Memory memory, long l) {
            return new Structure(this.type, this.layout, memory.slice(l));
        }
    }

    static final class Unsigned16
    extends MemoryOp {
        Unsigned16() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putShort(l, Util.uint16Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newUnsigned16(memory.getShort(l));
        }
    }

    static final class Unsigned32
    extends MemoryOp {
        Unsigned32() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putInt(l, Util.uint32Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newUnsigned32(memory.getInt(l));
        }
    }

    static final class Unsigned64
    extends MemoryOp {
        Unsigned64() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putLong(l, Util.uint64Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newUnsigned64(memory.getLong(l));
        }
    }

    static final class Unsigned8
    extends MemoryOp {
        Unsigned8() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            memory.putByte(l, Util.uint8Value(pyObject));
        }

        public final PyObject get(Memory memory, long l) {
            return Util.newUnsigned8(memory.getByte(l));
        }
    }

    private static final class VoidOp
    extends MemoryOp {
        private VoidOp() {
        }

        public final void put(Memory memory, long l, PyObject pyObject) {
            throw Py.TypeError("Attempting to write void to memory");
        }

        public final PyObject get(Memory memory, long l) {
            throw Py.TypeError("Attempting to read void from memory");
        }
    }
}

